/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking.packet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.OriginsForge;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.integration.OriginEventsArchitectury;
import io.github.apace100.origins.networking.packet.AcknowledgeMessage;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.SerializableData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class DynamicRegistryMessage
implements IntSupplier {
    private final Map<ResourceLocation, PowerType<?>> powers;
    private final Map<ResourceLocation, SerializableData.Instance> origins;
    private final List<OriginLayer> layers;
    private int loginIndex;

    public static DynamicRegistryMessage decode(PacketBuffer buf) {
        int size = buf.func_150792_a();
        Origins.LOGGER.info("Server sent {} powers", (Object)size);
        HashMap powers = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            if (!buf.readBoolean()) continue;
            ResourceLocation powerId = buf.func_192575_l();
            ResourceLocation factoryId = buf.func_192575_l();
            PowerFactory factory = (PowerFactory)((Object)ModRegistriesArchitectury.POWER_FACTORY.get(factoryId));
            PowerFactory.Instance factoryInstance = factory.read(buf);
            PowerType type = new PowerType(powerId, factoryInstance);
            type.setTranslationKeys(buf.func_218666_n(), buf.func_218666_n());
            if (buf.readBoolean()) {
                type.setHidden();
            }
            powers.put(powerId, type);
        }
        size = buf.func_150792_a();
        Origins.LOGGER.info("Server sent {} origins", (Object)size);
        HashMap<ResourceLocation, SerializableData.Instance> origins = new HashMap<ResourceLocation, SerializableData.Instance>(size);
        for (int i = 0; i < size; ++i) {
            origins.put(buf.func_192575_l(), Origin.DATA.read(buf));
        }
        size = buf.func_150792_a();
        Origins.LOGGER.info("Server sent {} layers", (Object)size);
        ArrayList<OriginLayer> layers = new ArrayList<OriginLayer>(size);
        for (int i = 0; i < size; ++i) {
            layers.add(OriginLayer.read(buf));
        }
        return new DynamicRegistryMessage(powers, origins, layers);
    }

    public DynamicRegistryMessage(Map<ResourceLocation, PowerType<?>> powers, Map<ResourceLocation, SerializableData.Instance> origins, List<OriginLayer> layers) {
        this.powers = ImmutableMap.copyOf(powers);
        this.origins = ImmutableMap.copyOf(origins);
        this.layers = ImmutableList.copyOf(layers);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.powers.size());
        this.powers.forEach((key, type) -> {
            PowerFactory.Instance factory = type.getFactory();
            buf.writeBoolean(factory != null);
            if (factory != null) {
                buf.func_192572_a(key);
                factory.write(buf);
                buf.func_180714_a(type.getOrCreateNameTranslationKey());
                buf.func_180714_a(type.getOrCreateDescriptionTranslationKey());
                buf.writeBoolean(type.isHidden());
            }
        });
        buf.func_150787_b(this.origins.size());
        this.origins.forEach((key, value) -> {
            buf.func_192572_a(key);
            Origin.DATA.write(buf, (SerializableData.Instance)value);
        });
        buf.func_150787_b(this.layers.size());
        this.layers.forEach(layer -> layer.write(buf));
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            PowerTypeRegistry.clear();
            OriginRegistry.reset();
            OriginLayers.clear();
            this.powers.forEach(PowerTypeRegistry::register);
            Origins.LOGGER.info("Loaded {} powers from server on client", (Object)this.powers.size());
            ((OriginDataLoadedCallback)OriginEventsArchitectury.POWER_TYPES_LOADED.invoker()).onDataLoaded(true);
            this.origins.forEach((id, data) -> OriginRegistry.register(id, Origin.createFromData(id, data)));
            Origins.LOGGER.info("Loaded {} origins from server on client", (Object)this.origins.size());
            ((OriginDataLoadedCallback)OriginEventsArchitectury.ORIGINS_LOADED.invoker()).onDataLoaded(true);
            this.layers.forEach(OriginLayers::add);
            Origins.LOGGER.info("Loaded {} layers from server on client", (Object)this.layers.size());
            ((OriginDataLoadedCallback)OriginEventsArchitectury.ORIGIN_LAYERS_LOADED.invoker()).onDataLoaded(true);
        });
        OriginsForge.channel.reply((Object)new AcknowledgeMessage(), contextSupplier.get());
        contextSupplier.get().setPacketHandled(true);
    }

    public int getLoginIndex() {
        return this.loginIndex;
    }

    public void setLoginIndex(int loginIndex) {
        this.loginIndex = loginIndex;
    }

    @Override
    public int getAsInt() {
        return this.loginIndex;
    }
}

